/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.pack;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.utils.JsonUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TrainerType
implements Serializable {
    public static final long serialVersionUID = 0L;
    public static final TrainerType DEFAULT = new TrainerType();
    private static final Map<String, TrainerType> REGISTRY = new HashMap<String, TrainerType>();
    private static int counter;
    private final String name;
    private final String symbol;
    private final Color color;
    @JsonUtils.Exclude
    private String id = "";
    @JsonUtils.Exclude
    private int numericId = -1;

    public static void register(String id, TrainerType trainerType) {
        trainerType.numericId = counter++;
        trainerType.id = id;
        if (REGISTRY.put(id, trainerType) != null) {
            ModCommon.LOG.error("duplicate trainer types '" + trainerType.id() + "'");
        }
    }

    public static Collection<TrainerType> values() {
        return REGISTRY.values();
    }

    public static Set<String> ids() {
        return REGISTRY.keySet();
    }

    public static void clear() {
        REGISTRY.clear();
        counter = 0;
    }

    public static TrainerType valueOf(String id) {
        return REGISTRY.getOrDefault(id, DEFAULT);
    }

    public TrainerType() {
        this("UNKNOWN");
    }

    public TrainerType(String name) {
        this(name, new Color(0xFFFFFF));
    }

    public TrainerType(String name, Color color) {
        this(name, "", color);
    }

    public TrainerType(String name, String symbol) {
        this(name, symbol, new Color(0xFFFFFF));
    }

    public TrainerType(String name, String symbol, Color color) {
        this.name = name;
        this.symbol = symbol;
        this.color = color;
    }

    public String name() {
        return this.name;
    }

    public String symbol() {
        return this.symbol;
    }

    public String id() {
        return this.id;
    }

    public int color() {
        return this.color.rgb();
    }

    public String toString() {
        return String.format("0x%02x:%s/%s", this.numericId, this.id, this.name);
    }

    public int hashCode() {
        return this.numericId;
    }

    public boolean equals(Object o) {
        if (o instanceof TrainerType) {
            TrainerType other = (TrainerType)o;
            return this.numericId == other.numericId;
        }
        return false;
    }

    public record Color(int rgb) implements Serializable
    {
        private static final long serialVersionUID = 1L;

        public static class Deserializer
        implements JsonDeserializer<Color> {
            public Color deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    try {
                        return new Color(json.getAsInt());
                    }
                    catch (NumberFormatException e) {
                        String s = json.getAsString().toLowerCase();
                        if (s.isEmpty()) {
                            s = "ffffff";
                        } else if (s.startsWith("0x")) {
                            s = s.substring(2);
                        }
                        return new Color(Integer.parseInt(s, 16));
                    }
                }
                catch (Exception e) {
                    throw new JsonParseException((Throwable)e);
                }
            }
        }

        public static class Serializer
        implements JsonSerializer<Color> {
            public JsonElement serialize(Color src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(String.format("%06x", src.rgb()));
            }
        }
    }
}

